<?php

namespace Nidec\LaravelOauthClient\Tests;

use Nidec\LaravelOauthClient\ServiceProvider;
use Nidec\LaravelOauthClient\Tests\Mocks\MockController;
use Illuminate\Contracts\Config\Repository;
use Illuminate\Routing\Router;
use Orchestra\Testbench\TestCase as Orchestra;

class TestCase extends Orchestra
{
    /**
     * Get package providers.
     *
     * @param  \Illuminate\Foundation\Application  $app
     *
     * @return array
     */
    protected function getPackageProviders($app)
    {
        return [ServiceProvider::class];
    }

    /**
     * Get package aliases.
     *
     * @param  \Illuminate\Foundation\Application  $app
     *
     * @return array
     */
    protected function getPackageAliases($app)
    {
        return [];
    }

    protected function defineEnvironment($app)
    {
        /** @var Router $router */
        $router = $app['router'];

        $this->addWebRoutes($router);
        $this->addApiRoutes($router);
        $this->addViewPaths();

        tap($app['config'], function (Repository $config) {
            $config->set('auth.guards.oauth.driver', 'oauth');

            $config->set('oauth_client.authorize_endpoint', 'https://authorize');
            $config->set('oauth_client.token_endpoint', 'https://token');
            $config->set('oauth_client.me_endpoint', 'https://me');
        });
    }

    /**
     * @param Router $router
     */
    protected function addWebRoutes(Router $router)
    {
        $router->get('web/index', [ MockController::class, 'index' ])->middleware(['web', 'auth:oauth']);
    }

    /**
     * @param Router $router
     */
    protected function addApiRoutes(Router $router)
    {
        $router->get('api/ping', [
            'uses' => function () {
                return response()->json(['status' => 'pong']);
            }
        ])->middleware('auth:oauth');
    }

    protected function addViewPaths()
    {
        config(['view.paths' => array_merge(config('view.paths'), [__DIR__ . '/resources/views'])]);
    }
}