<?php

namespace Nidec\LaravelOauthClient;

use Illuminate\Auth\GuardHelpers;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;

class OAuthGuard implements Guard
{
    use GuardHelpers;

    /**
     * @inheritDoc
     */
    public function user(): ?Authenticatable
    {
        if ($this->user !== null) {
            return $this->user;
        }

        $accessToken = request()->bearerToken() ?? Session::get('access_token');
        if (empty($accessToken)) {
            return null;
        }

        $url = config('oauth_client.auth_server') . config('oauth_client.me_endpoint');

        $response = Http::withToken($accessToken)->get($url);

        throw_unless($response->ok());

        return App::makeWith(User::class, $response->json());
    }

    /**
     * @inheritDoc
     */
    public function validate(array $credentials = []): bool
    {
        if (empty($credentials['access_token'])) {
            return false;
        }

        $url = config('oauth_client.auth_server') . config('oauth_client.me_endpoint');

        $response = Http::withToken($credentials['access_token'])
            ->acceptJson()
            ->get($url);

        return $response->successful();
    }
}
