<?php

return [
    /*
     * Client id created for this client by the authorization server
     */
    'client_id' => env('AUTH_CLIENT_ID'),

    /*
     * The url of the authorization server
     */
    'auth_server' => env('AUTH_SERVER', 'https://auth.nidec-asi.com'),

    /*
     * The oauth authorization endpoint to authenticate and retrieve an access code
     */
    'authorize_endpoint' => env('AUTH_AUTHORIZE_ENDPOINT', '/oauth/authorize'),

    /*
     * The oauth token endpoint to exchange the access code against an access token and refresh token
     */
    'token_endpoint' => env('AUTH_TOKEN_ENDPOINT', '/oauth/token'),

    /*
     * The endpoint that verify the token and returns the connected user infos
     */
    'me_endpoint' => env('AUTH_ME_ENDPOINT', '/api/me'),

    /*
     * The scopes requested by your app
     */
    'scopes' => env('AUTH_SCOPES', ''),
];
